### 概览

本章主要描述了常用数据类型、相机服务算子库、基础视觉算子库和时间序列算子库在MateFacture中调用的接口。这些接口提供了一种可通过st脚本在PLC工程中实现对相机的操作以及对图像和时间序列的处理。

---

### 常用数据类型

![](https://resource.helplook.net/docker_production/3648ne/article/Jwjw3WLJ/67568bfda4e50.png)

---

### 视觉基础算子库

图像操作

F\_CV\_ReadImage

![](https://resource.helplook.net/docker_production/3648ne/article/Jwjw3WLJ/67568c3ba5e88.png)

读取图像，从文件加载图像，目前，支持以下文件格式：

- Windows位图: \*.bmp, \*.dib;
- JPEG文件: \*.JPEG, \*.jpg, \*.jpe;
- JPEG 2000文件: \*.jp2;
- 便携式网络图形: \*.png;
- WebP: \*.WebP;
- 便携式图像格式: \*.ppm, \*.pgm, \*.ppm\*.pxm, \*.pnm;
- PFM文件: \*.PFM;
- 太阳光栅: \*.sr, \*.ras;
- TIFF文件: \*.TIFF, \*.tif;
- OpenEXR图像文件: \*.exr;
- 辐射HDR: \*.HDR，\*.pic;

Syntax

Definition:

> FUNCTION F\_CV\_ReadImage: HRESULT
> 
> VAR\_INPUT
> 
>  sFileName : STRING(1024);
> 
>  eFlags : E\_CvImreadModes := E\_CvImreadModes.IMREAD\_COLOR;
> 
>  nDestImage : REFERENCE TO ULINT;
> 
>  hrPrev : HRESULT := HRESULT.S\_FALSE;
> 
> END\_VAR

Inputs

| Name | Type | Description |
|---|---|---|
| sFilename | STRING | 要加载的文件的名称 |
| eFlags | E\_CvImreadModes | 图像解码类型  1\) IMREAD\_UNCHANGED: 解码不变  2\) IMREAD\_GRAYSCALE: 解码灰度  3\) IMREAD\_COLOR: 解码颜色 |
| nDestImage | REFERENCE TO ULINT | ram中加载的图像 |
| hrPrev | HRESULT | 算子的初始执行状况 |

F\_CV\_WriteImage

![](https://resource.helplook.net/docker_production/3648ne/article/Jwjw3WLJ/67580c5c2eaa6.png)

保存图像，将图像保存到指定文件，一般来说只能保存8位单通道或3通道（具有“BGR”通道顺序）图像，但以下情况除外：

- 16位无符号（16U）图像可以保存为PNG、JPEG 2000和TIFF格式；
- 32位浮点（32F）图像可以保存为PFM、TIFF、OpenEXR和Radiance HDR格式；

将使用LogLuv高动态范围编码（每像素4字节）保存3通道（32FC3）TIFF图像；使用此功能可以保存带有阿尔法通道的PNG图像。为此，创建8位（或16位）4通道图像BGRA，阿尔法通道位于最后。完全透明的像素的阿尔法应设置为0，完全不透明的像素的阿尔法应设置为255/65535。